/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.flowable;

import dev.compactmods.crafting.lib.reactivestreams.Subscriber;
import dev.compactmods.crafting.lib.reactivestreams.Subscription;
import dev.compactmods.crafting.lib.reactivex.rxjava3.annotations.Nullable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Flowable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.FlowableSubscriber;
import dev.compactmods.crafting.lib.reactivex.rxjava3.exceptions.Exceptions;
import dev.compactmods.crafting.lib.reactivex.rxjava3.functions.Action;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import dev.compactmods.crafting.lib.reactivex.rxjava3.operators.ConditionalSubscriber;
import dev.compactmods.crafting.lib.reactivex.rxjava3.operators.QueueSubscription;
import dev.compactmods.crafting.lib.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class FlowableDoFinally<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Action onFinally;

    public FlowableDoFinally(Flowable<T> source, Action onFinally) {
        super(source);
        this.onFinally = onFinally;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        if (s instanceof ConditionalSubscriber) {
            this.source.subscribe(new DoFinallyConditionalSubscriber((ConditionalSubscriber)s, this.onFinally));
        } else {
            this.source.subscribe(new DoFinallySubscriber<T>(s, this.onFinally));
        }
    }

    static final class DoFinallyConditionalSubscriber<T>
    extends BasicIntQueueSubscription<T>
    implements ConditionalSubscriber<T> {
        private static final long serialVersionUID = 4109457741734051389L;
        final ConditionalSubscriber<? super T> downstream;
        final Action onFinally;
        Subscription upstream;
        QueueSubscription<T> qs;
        boolean syncFused;

        DoFinallyConditionalSubscriber(ConditionalSubscriber<? super T> actual, Action onFinally) {
            this.downstream = actual;
            this.onFinally = onFinally;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                if (s instanceof QueueSubscription) {
                    this.qs = (QueueSubscription)s;
                }
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            this.downstream.onNext(t);
        }

        @Override
        public boolean tryOnNext(T t) {
            return this.downstream.tryOnNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.downstream.onError(t);
            this.runFinally();
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
            this.runFinally();
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
            this.runFinally();
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public int requestFusion(int mode) {
            QueueSubscription<T> qs = this.qs;
            if (qs != null && (mode & 4) == 0) {
                int m = qs.requestFusion(mode);
                if (m != 0) {
                    this.syncFused = m == 1;
                }
                return m;
            }
            return 0;
        }

        @Override
        public void clear() {
            this.qs.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.qs.isEmpty();
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            Object v = this.qs.poll();
            if (v == null && this.syncFused) {
                this.runFinally();
            }
            return v;
        }

        void runFinally() {
            if (this.compareAndSet(0, 1)) {
                try {
                    this.onFinally.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    RxJavaPlugins.onError(ex);
                }
            }
        }
    }

    static final class DoFinallySubscriber<T>
    extends BasicIntQueueSubscription<T>
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = 4109457741734051389L;
        final Subscriber<? super T> downstream;
        final Action onFinally;
        Subscription upstream;
        QueueSubscription<T> qs;
        boolean syncFused;

        DoFinallySubscriber(Subscriber<? super T> actual, Action onFinally) {
            this.downstream = actual;
            this.onFinally = onFinally;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                if (s instanceof QueueSubscription) {
                    this.qs = (QueueSubscription)s;
                }
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            this.downstream.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.downstream.onError(t);
            this.runFinally();
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
            this.runFinally();
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
            this.runFinally();
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public int requestFusion(int mode) {
            QueueSubscription<T> qs = this.qs;
            if (qs != null && (mode & 4) == 0) {
                int m = qs.requestFusion(mode);
                if (m != 0) {
                    this.syncFused = m == 1;
                }
                return m;
            }
            return 0;
        }

        @Override
        public void clear() {
            this.qs.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.qs.isEmpty();
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            Object v = this.qs.poll();
            if (v == null && this.syncFused) {
                this.runFinally();
            }
            return v;
        }

        void runFinally() {
            if (this.compareAndSet(0, 1)) {
                try {
                    this.onFinally.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    RxJavaPlugins.onError(ex);
                }
            }
        }
    }
}

